/* --COPYRIGHT--,BSD
 * Copyright (c) 2012, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * --/COPYRIGHT--*/
#include "hal_TLV.h"

/* Function Defintion
   Passing parameters:
      tag - The specific/particular tag information (length and data address location) required by the user
      *length - Address of the variable (byte long) where the number of bytes allocated for the particular 'tag' is to be stored
      *data_address - Address of the variable (word long) which is used to access the value info of the the particular 'tag' (in the TLV structure)

  NOTE: If 'length' and 'data_address' returned = 0, it implies that there was no tag match. This condition can be checked for in the
        main function that calls this Get_TLV_info(..) function and appropriate actions can be taken
*/

void Get_TLV_info(unsigned char tag, unsigned char *length, unsigned int ** data_address)
{
  volatile char *TLV_address = (char *)TLV_START;               // TLV Structure Start Address
  
  while((*TLV_address != tag) && (*TLV_address != TLV_TAGEND) && (TLV_address < (char *)TLV_END))
  {
    TLV_address += *(TLV_address+1) + 2;               // add (Current TAG address + LENGTH) + 2
  }
  if (*TLV_address == tag)                             // Check if Tag match happened..
  {
    *length = *(TLV_address+1);                        // Return length = Address + 1
    *data_address = (unsigned int *)(TLV_address+2);     // Return address of first data/value info = Address + 2
  }
  else                                                 // If there was no tag match and the end of TLV structure was reached..
  {
    *length = 0;                                       // Return 0 for TAG not found
    data_address = 0;                                  // Return 0 for TAG not found
  }
}

/* Function Defintion
   Returns 
      device_type - either F5438 or F5438A, depending on device
*/
device_t Get_Device_Type(void)
{
  device_t device_type;  
  /* Check for device type - either F5438 or F5438A */  
  if(*((char *)DEVICE_ID_0) == 0x54 && *((char *)DEVICE_ID_1) == 0x38) 
  	device_type = F5438; 
  else if (*((char *)DEVICE_ID_0) == 0x05 && *((char *)DEVICE_ID_1) == 0x80)
  	device_type = F5438A; 
  
  return device_type; 
}
